//=============================================================================
// MissionProgress
//
// One of these per player. 128 mission 'slots', int is state of mission
//
// NOTE: if(Level.NetMode == NM_Standalone) //which means "if singleplayer..."
//=============================================================================
class MissionProgress extends Actor;

var int missionState[128];

var string ownerName; //basic ID if player leaves and rejoins. IP is no good because of dynamics. Abusable, but not serious
var bool bDestroying;
var MPConvo_Essential MPE;
//var float DEBUGTIMER;

function Tick(float deltaTime)
{
	if(Owner == None)
	{
		if(bDestroying == false)
		{
			SetTimer(900, false); //Don't destroy immediately; give player a chance to reconnect
			bDestroying = true;
		}
	}
	else
	{
		if((bDestroying == true) && (Owner != None))//if the owner magically returns (via mutator), stop the cleanup
		{
			SetTimer(0, false);
		}
	}

	
	//if(DEBUGTIMER <= Level.TimeSeconds)
	//{
	//	BroadcastMessage("DEBUG: My owner is "$DeusExPlayer(Owner).PlayerReplicationInfo.PlayerName);
	//	DEBUGTIMER = Level.TimeSeconds += 2.0;
	//}

	Super.Tick(deltaTime);
}

function Timer() //if the player hasn't reconnected in 15 minutes, clean this actor up
{
	//BroadcastMessage("DEBUG: MissionProgress actor destroyed");
	Destroy(); 
}

function BeginPlay()
{
	local MPConvo_Essential MPE2;

	foreach AllActors(class'MPConvo_Essential',MPE2)
	{
		MPE = MPE2; //silly; lazy
	}

	ownerName = DeusExPlayer(Owner).PlayerReplicationInfo.PlayerName;

	Super.BeginPlay();
}

function int GetMissionState(int mission, bool bCoop)
{
	local MPConvo_Essential A;

	if(bCoop == false)
	{
		return missionState[mission];
	}
	else
	{
		return MPE.GetMissionState(mission);
	}
}

function SetMissionState(int mission, int setState, bool bCoop)
{
	if(mission != 0)
	{
		if(setState != -999) //default value; ignore
		{
			if(bCoop == false)
			{
				missionState[mission] = setState;
			}
			else
			{
				MPE.SetMissionState(mission, setState);
			}
		}
	}
	else
	{
		log("=====================================");
		log("   MPConvo: DON'T USE MISSION 0!");
		log("=====================================");
	}
}

defaultproperties
{
     bHidden=True
     bDestroying=False
}